<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Wyniki głosowania</title>
</head>
<body>
<h2>Wyniki głosowania</h2>
<div>
<?php
$datafile = "/var/wwwdata/colors.txt";

function vote()
{
  global $datafile;
  if(!isset($_GET["vote"]) || $_GET["vote"] == ""){
    echo "Nie został zaznaczony żaden z kolorów.";
    return false;
  }
  else{
    $color = $_GET["vote"];
  }

  if(file_exists($datafile)){
    if(($fd = fopen($datafile, "r+")) === false){
      echo "Błąd serwera. Głos nie został uwzględniony.";
      return false;
    }
  }
  else{
    if(($fd = fopen($datafile, "w+")) === false){
      echo "Błąd serwera. Głos nie został uwzględniony.";
      return false;
    }
  }
  
  $czerwony = intval(fgets($fd));
  $zielony = intval(fgets($fd));
  $niebieski = intval(fgets($fd));
  $fioletowy = intval(fgets($fd));
  $czarny = intval(fgets($fd));

  switch($color){
    case "czerwony" : $czerwony++; break;
    case "zielony" : $zielony++; break;
    case "niebieski" : $niebieski++; break;
    case "fioletowy" : $fioletowy++; break;
    case "czarny" : $czarny++; break;
  }
  
  flock($fd, LOCK_EX);
  
  fseek($fd, 0);
  fputs($fd, $czerwony."\r\n");
  fputs($fd, $zielony."\r\n");
  fputs($fd, $niebieski."\r\n");
  fputs($fd, $fioletowy."\r\n");
  fputs($fd, $czarny."\r\n");
  
  flock($fd, LOCK_UN);
  fclose($fd);
  return true;
}

function show()
{
  global $datafile;
  
  if(file_exists($datafile)){
    if(($fd = fopen($datafile, "r")) === false){
      echo "Błąd serwera. Wyniki ankiety nie są dostępne.";
      return;
    }
  }
  else{
    if(($fd = fopen($datafile, "w+")) === false){
      echo "Błąd serwera. Wyniki ankiety nie są dostępne.";
      return;
    }
  }

  $czerwony = intval(fgets($fd));
  $zielony = intval(fgets($fd));
  $niebieski = intval(fgets($fd));
  $fioletowy = intval(fgets($fd));
  $czarny = intval(fgets($fd));

  $votes_no = $czerwony + $zielony + $niebieski + $fioletowy + $czarny;
  $votes_no == 0?$votes_no = 1:0;

  $czerwony_proc = sprintf("%.2f", $czerwony * 100 / $votes_no);
  $zielony_proc = sprintf("%.2f", $zielony * 100 / $votes_no);
  $niebieski_proc = sprintf("%.2f", $niebieski * 100 / $votes_no);
  $fioletowy_proc = sprintf("%.2f", $fioletowy * 100 / $votes_no);
  $czarny_proc = sprintf("%.2f", $czarny * 100 / $votes_no);
  echo "<table border='1'>";

  echo "<tr><td>Nazwa koloru</td><td>Liczba głosów</td>";
  echo "<td>Procent głosów</td></tr>";

  echo "<tr><td>czerwony</td><td>$czerwony</td>";
  echo "<td>$czerwony_proc</td></tr>";

  echo "<tr><td>zielony</td><td>$zielony</td>";
  echo "<td>$zielony_proc</td></tr>";

  echo "<tr><td>niebieski</td><td>$niebieski</td>";
  echo "<td>$niebieski_proc</td></tr>";

  echo "<tr><td>fioletowy</td><td>$fioletowy</td>";
  echo "<td>$fioletowy_proc</td></tr>";

  echo "<tr><td>czarny</td><td>$czarny</td>";
  echo "<td>$czarny_proc</td></tr>";

  echo "</table>";
}

if(isSet($_GET["action"])){
  if($_GET["action"] == "show"){
    show();
  }
  else if($_GET["action"] == "vote"){
    if(vote()) show();
  }
  else{
    echo "Otrzymano nieprawidłowe dane.";
  }
}
else{
  echo "Otrzymano nieprawidłowe dane.";
}
?>
</div>
</body>
</html>
